
/* Weitere Hierarchiekonzepte */
-- Auslagerung der Hierarchie in eine eigene Tabelle
create table employee as
select empno, ename, job, sal, comm, hiredate, deptno
  from emp;
  
create table employee_hierarchy as
select empno, nvl(mgr, empno) mgr, 
       hiredate valid_from, to_date('31.12.2099', 'dd.mm.yyyy') valid_to
  from emp;
  
alter table employee add
constraint pk_employee primary key (empno);

alter table employee_hierarchy add
constraint fk_emp_hier_emp_empno
  foreign key (empno) references employee(empno)
  on delete cascade;
  
alter table employee_hierarchy add
constraint fk_emp_hier_emp_mgr
  foreign key (mgr) references employee(empno)
  on delete cascade;
  
alter table employee_hierarchy add
constraint pk_emp_hier primary key (empno, mgr, valid_from);

-- Einfache Connect-By-Abfrage
 select level,
        lpad('.', (level - 1) * 2, '.') || e.ename name
   from employee e
   join employee_hierarchy h on e.empno = h.empno
  start with h.mgr = h.empno
connect by nocycle prior h.empno = h.mgr;

-- Änderung der Daten, um mehrere Manager zu ermöglichen und eine
-- Änderung über die Zeit zu demonstrieren
update employee_hierarchy
   set valid_to = to_date('15.05.2010', 'dd.mm.yyyy') -
                    interval '1' second
 where empno = 7499;
 
insert into employee_hierarchy(empno, mgr, valid_from, valid_to)
values (7499, 7839, 
        to_date('15.05.2010', 'dd.mm.yyyy'), 
        to_date('31.12.2099', 'dd.mm.yyyy'));
        
insert into employee_hierarchy(empno, mgr, valid_from, valid_to)
select empno, 7839, valid_from, valid_to
  from employee_hierarchy
 where empno = 7844;
 
-- Abfrage des neuen Datenbestands
 select level, h.empno, 
        lpad('.', (level - 1) * 2, '.') || e.ename name
   from employee e
   join employee_hierarchy h on e.empno = h.empno
  where sysdate between valid_from and valid_to
  start with h.mgr = h.empno
connect by nocycle prior h.empno = h.mgr;

-- Abfrage für die Vergangenheit, ALLEN ist wieder BLAKE unterstellt
 select level, h.empno, 
        lpad('.', (level - 1) * 2, '.') || e.ename name
   from employee e
   join employee_hierarchy h on e.empno = h.empno
  where to_date('14.05.2010', 'dd.mm.yyyy') between valid_from and valid_to
  start with h.mgr = h.empno
connect by nocycle prior h.empno = h.mgr;

rollback;


-- CLOSURE TABLE
-- Erzeugung einer Closure-Tabelle aus der bestehenden Tabelle EMP
drop table hierarchy_closure;
create table hierarchy_closure as
select h.ename mitarbeiter, e.ename vorgaenger
  from emp e
  join ( select ename, sys_connect_by_path(ename, '|') pfad
           from emp
          start with mgr is null
        connect by prior empno = mgr) h
    on instr(h.pfad, e.ename) > 0;
    
-- Einträge des Mitarbeiters ADAMS
select *
  from hierarchy_closure
 where mitarbeiter = 'ADAMS';
    
-- Einen neuen Mitarbeiter einfügen
insert into hierarchy_closure
select 'WILLIAMS', vorgaenger
  from hierarchy_closure
 where mitarbeiter = 'SCOTT' 
union all
select 'WILLIAMS', 'WILLIAMS' from dual;

select *
  from hierarchy_closure
 where mitarbeiter = 'WILLIAMS';
    
-- Umhängen eines Teilbaums
delete
  from hierarchy_closure
 where vorgaenger in (
       select vorgaenger
         from hierarchy_closure
        where mitarbeiter = 'SCOTT')
   and mitarbeiter in (
       select mitarbeiter
         from hierarchy_closure
        where vorgaenger = 'SCOTT'
          and mitarbeiter != vorgaenger);

-- Insert-Abfrage zum Einfügen neuer Daten in den Baum         
select v.mitarbeiter, n.vorgaenger
  from hierarchy_closure v
 cross join
       hierarchy_closure n
 where v.vorgaenger = 'SCOTT'
   and n.mitarbeiter = 'MARTIN';
